package ru.yandex.travel.hotels.administrator.entity;

import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.hotels.administrator.grpc.proto.EInternalUnpublishedReason;

@AllArgsConstructor
@Getter
public enum UnpublishedReason {
    AGENCY("agency"),
    ADDITIONAL_SERVICES("additional services"),
    APARTMENTS("apartments"),
    HOTEL_INITIATIVE("hotel initiative"),
    OTHER("other");

    private static final Map<EInternalUnpublishedReason, UnpublishedReason> fromProtoUnpublishedReasonMap = Map.of(
            EInternalUnpublishedReason.IUR_AGENCY, AGENCY,
            EInternalUnpublishedReason.IUR_ADDITIONAL_SERVICES, ADDITIONAL_SERVICES,
            EInternalUnpublishedReason.IUR_APARTMENTS, APARTMENTS,
            EInternalUnpublishedReason.IUR_HOTEL_INITIATIVE, HOTEL_INITIATIVE,
            EInternalUnpublishedReason.IUR_OTHER, OTHER
    );

    private static final Map<UnpublishedReason, EInternalUnpublishedReason> toProtoUnpublishedReasonMap = Map.of(
            AGENCY, EInternalUnpublishedReason.IUR_AGENCY,
            ADDITIONAL_SERVICES, EInternalUnpublishedReason.IUR_ADDITIONAL_SERVICES,
            APARTMENTS, EInternalUnpublishedReason.IUR_APARTMENTS,
            HOTEL_INITIATIVE, EInternalUnpublishedReason.IUR_HOTEL_INITIATIVE,
            OTHER, EInternalUnpublishedReason.IUR_OTHER
    );

    private final String value;

    public static UnpublishedReason convertFromProto(EInternalUnpublishedReason unpublishedReasonProto) {
        if (fromProtoUnpublishedReasonMap.containsKey(unpublishedReasonProto)) {
            return fromProtoUnpublishedReasonMap.get(unpublishedReasonProto);
        } else {
            throw new RuntimeException(String.format("Unpublished reason %s is not found in the mapping", unpublishedReasonProto));
        }
    }

    public static EInternalUnpublishedReason convertToProto(UnpublishedReason unpublishedReason) {
        if (toProtoUnpublishedReasonMap.containsKey(unpublishedReason)) {
            return toProtoUnpublishedReasonMap.get(unpublishedReason);
        } else {
            throw new RuntimeException(String.format("Unpublished reason %s is not found in the mapping", unpublishedReason));
        }
    }
}
