package ru.yandex.travel.hotels.administrator.entity;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;

@Entity
@DiscriminatorValue(value = "update_balance_data")
@Getter
@Setter
public class UpdateBalanceDataStep extends LegalDetailsConnectionStep {
    @Override
    public String getEntityType() {
        return WorkflowEntityType.UPDATE_BALANCE_DATA_STEP.getDiscriminatorValue();
    }

    public static UpdateBalanceDataStep createNewStepFor(LegalDetails legalDetails) {
        return initNewStep(new UpdateBalanceDataStep(), legalDetails);
    }
}
