package ru.yandex.travel.hotels.administrator.entity

import org.hibernate.annotations.CreationTimestamp
import org.hibernate.annotations.UpdateTimestamp
import ru.yandex.travel.hotels.administrator.grpc.proto.AdminRole
import java.time.Instant
import java.util.*
import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.Id
import javax.persistence.Table

@Entity
@Table(name = "user_roles")
open class UserRole (
    @Id
    var id: UUID = UUID.randomUUID(),

    @Column(name = "login")
    var login: String = "",

    @Column(name = "passport_uid")
    var passportUid: String = "",

    @Column(name = "role")
    var role: AdminRole = AdminRole.AR_INVALID,

    @CreationTimestamp
    var createdAt: Instant = Instant.now(),

    @UpdateTimestamp
    var updatedAt: Instant = Instant.now(),
)
