package ru.yandex.travel.hotels.administrator.entity;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.hotels.proto.EPartnerId;

@Entity
@DiscriminatorValue(value = "verify_clustering")
@Getter
@Setter
public class VerifyClusteringStep extends HotelConnectionStep {

    private String hotelConnectionStTicket;

    private String hotelCode;

    private Long permalink;

    private String hotelName;

    @Type(type = "proto-enum")
    private EPartnerId partnerId;

    @Override
    public String getEntityType() {
        return WorkflowEntityType.VERIFY_CLUSTERING_STEP.getDiscriminatorValue();
    }
}
