package ru.yandex.travel.hotels.administrator.health;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.hotels.common.PartnerConfigService;

@Component
@RequiredArgsConstructor
public class PartnerConfigHealthIndicator implements HealthIndicator {
    private final PartnerConfigService partnerConfigService;

    @Override
    public Health health() {
        if (partnerConfigService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }

}
