package ru.yandex.travel.hotels.administrator.repository;

import java.util.Collection;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import ru.yandex.travel.hotels.administrator.workflow.proto.EConnectionStepState;
import ru.yandex.travel.workflow.EWorkflowState;

@Component
@RequiredArgsConstructor
public class CustomConnectionStepRepositoryImpl implements CustomConnectionStepRepository {

    private final EntityManager em;

    @Override
    public List<UUID> getAwaitingStepsInStartedStateAndNotSentAnswer(EConnectionStepState stepState,
                                                                     EWorkflowState workflowState,
                                                                     Collection<UUID> exclusions,
                                                                     Pageable pageable) {
        Query query = em.createQuery(commonJpaQuery("step.id", exclusions, true));
        query.setParameter("workflowState", workflowState);
        query.setParameter("stepState", stepState);
        query.setParameter("ticketResultFetched", false);
        if (!exclusions.isEmpty()) {
            query.setParameter("exclusions", exclusions);
        }
        query.setFirstResult((int) pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        return query.getResultList();
    }

    @Override
    public long countAwaitingStepsInStartedStateAndNotSentAnswer(EConnectionStepState stepState,
                                                                 EWorkflowState workflowState,
                                                                 Collection<UUID> exclusions) {
        Query query = em.createQuery(commonJpaQuery("count(step)", exclusions, false));
        query.setParameter("workflowState", workflowState);
        query.setParameter("stepState", stepState);
        query.setParameter("ticketResultFetched", false);
        if (!exclusions.isEmpty()) {
            query.setParameter("exclusions", exclusions);
        }
        return (Long) query.getResultList().get(0);
    }

    private String commonJpaQuery(String selectPart, Collection<UUID> exclusions, boolean orderByCheckedAt) {
        return "SELECT " + selectPart + " FROM ru.yandex.travel.hotels.administrator.entity.ConnectionStep step " +
                "INNER JOIN step.workflow w " +
                "WHERE step.ticketResultFetched = :ticketResultFetched " +
                (exclusions.isEmpty() ? "" : "AND step.id NOT IN (:exclusions) ") +
                "AND w.state = :workflowState AND step.state = :stepState " +
                (orderByCheckedAt ? "ORDER BY step.checkedAt NULLS FIRST" : "");
    }
}
