package ru.yandex.travel.hotels.administrator.repository;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.entity.LegalDetails;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionState;
import ru.yandex.travel.hotels.proto.EPartnerId;

public interface HotelConnectionRepository extends JpaRepository<HotelConnection, UUID> {

    HotelConnection findByPartnerIdAndHotelCode(EPartnerId partnerId, String hotelCode);

    List<HotelConnection> findByPermalink(Long permalink);

    List<HotelConnection> findAllByState(EHotelConnectionState state);

    @Query(value = "select hc.state, count(hc) from HotelConnection hc group by hc.state")
    List<Object[]> countHotelConnectionsByState();

    @Query(value = "select hc from HotelConnection hc where hc.legalDetails.inn in :inns")
    Set<HotelConnection> findAllWithAnyInn(@Param("inns") Set<String> inns);

    Set<HotelConnection> findAllByLegalDetails(LegalDetails legalDetails);

    List<HotelConnection> findAllByPartnerId(EPartnerId partnerId);
}
