package ru.yandex.travel.hotels.administrator.repository;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.entity.HotelConnectionUpdate;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionUpdateState;

public interface HotelConnectionUpdateRepository extends JpaRepository<HotelConnectionUpdate, UUID> {

    Optional<HotelConnectionUpdate> findFirstByHotelConnectionAndState(HotelConnection hotelConnection,
                                                                       EHotelConnectionUpdateState state);

    List<HotelConnectionUpdate> findAllByStTicket(String stTicket);
}
