package ru.yandex.travel.hotels.administrator.repository;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.persistence.LockModeType;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.hotels.administrator.entity.LegalDetails;
import ru.yandex.travel.hotels.administrator.workflow.proto.ELegalDetailsState;

public interface LegalDetailsRepository extends JpaRepository<LegalDetails, UUID> {
    Set<UUID> NO_EXCLUDE_IDS = Set.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    @Lock(LockModeType.OPTIMISTIC_FORCE_INCREMENT)
    LegalDetails findByInnAndKppAndBicAndPaymentAccount(String inn, String kpp, String bic, String paymentAccount);

    LegalDetails findByBalanceClientIdAndBalanceContractIdAndBalancePersonId(long clientId, long contractId, long personId);

    @Query(value = "select details.state, count(details) from LegalDetails details group by details.state")
    List<Object[]> countLegalDetailsByState();

    List<LegalDetails> findAllByState(ELegalDetailsState state);

    @Query("SELECT ld.id FROM LegalDetails ld " +
            "WHERE (ld.flagsSynchronizedAt < ?1 OR ld.flagsSynchronizedAt IS null) AND ld.id NOT IN ?2 " +
            "AND ld.state = ?3 " +
            "ORDER BY ld.flagsSynchronizedAt ASC NULLS FIRST")
    List<UUID> findIdsForFlagsSynchronization(Instant lastSynchronizedAt, Set<UUID> excludeIds,
                                              ELegalDetailsState state, Pageable pageable);

    @Query("SELECT count(ld) FROM LegalDetails ld " +
            "WHERE (ld.flagsSynchronizedAt < ?1 OR ld.flagsSynchronizedAt IS null) AND ld.id NOT IN ?2 " +
            "AND ld.state = ?3")
    long countIdsForFlagsSynchronization(Instant lastSynchronizedAt, Set<UUID> excludeIds, ELegalDetailsState state);

    @Query("SELECT MIN(CASE WHEN ld.flagsSynchronizedAt IS NOT NULL THEN ld.flagsSynchronizedAt ELSE ld.updatedAt END) " +
            "FROM LegalDetails ld " +
            "WHERE ld.flagsSynchronizedAt < ?1 OR ld.flagsSynchronizedAt IS null " +
            "AND ld.state = ?2")
    Instant findOldestTimestampForBillingFlagSynchronization(Instant lastSynchronizedAt, ELegalDetailsState state);
}
