package ru.yandex.travel.hotels.administrator.repository;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.hotels.administrator.entity.LegalDetails;
import ru.yandex.travel.hotels.administrator.entity.LegalDetailsUpdate;
import ru.yandex.travel.hotels.administrator.entity.LegalDetailsUpdateState;

public interface LegalDetailsUpdateRepository extends JpaRepository<LegalDetailsUpdate, UUID> {
    int countByLegalDetailsAndStateIn(LegalDetails legalDetails, Set<LegalDetailsUpdateState> states);

    List<LegalDetailsUpdate> findByLegalDetails(LegalDetails legalDetails);

    List<LegalDetailsUpdate> findByLegalDetailsAndStateInOrderByCreatedAt(
            LegalDetails legalDetails, Set<LegalDetailsUpdateState> states);
}
