package ru.yandex.travel.hotels.administrator.repository

import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.stereotype.Repository
import ru.yandex.travel.hotels.administrator.entity.UserRole
import ru.yandex.travel.hotels.administrator.grpc.proto.AdminRole


@Repository
interface UserRoleRepository : JpaRepository<UserRole, String?> {
    fun findByPassportUidAndRole(passportUid: String, role: AdminRole): UserRole?
    fun findAllByPassportUid(passportUid: String): List<UserRole>
    fun removeAllByLoginAndRole(login: String, role: AdminRole): Long
}
