package ru.yandex.travel.hotels.administrator.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.springframework.stereotype.Service;

@Service
public class CommentParser {

    private static final Pattern COMMENT_PATTERN = Pattern.compile("clientId.* (\\d+).*contractId.* (\\d+)", Pattern.CASE_INSENSITIVE);

    public BalanceData extractBalanceDataFromComment(String comment) {
        Matcher matcher = COMMENT_PATTERN.matcher(comment);
        if (matcher.find()) {
            try {
                long clientId = Long.parseLong(matcher.group(1));
                long contractId = Long.parseLong(matcher.group(2));
                return new BalanceData(clientId, contractId);
            } catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse clientId in balance ticket: " + comment, e);
            }
        } else {
            throw new IllegalArgumentException("Unable to parse comment in balance ticket: " + comment);
        }
    }

    @RequiredArgsConstructor
    @Getter
    @Setter
    public static class BalanceData {
        private final Long clientId;
        private final Long contractId;
    }

}
