package ru.yandex.travel.hotels.administrator.service;

import java.util.concurrent.ExecutionException;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.travel.hotels.common.PartnerConfigService;
import ru.yandex.travel.hotels.geosearch.GeoSearchService;
import ru.yandex.travel.hotels.geosearch.model.GeoHotel;
import ru.yandex.travel.hotels.geosearch.model.GeoHotelOriginalId;
import ru.yandex.travel.hotels.geosearch.model.GeoOriginEnum;
import ru.yandex.travel.hotels.geosearch.model.GeoSearchReq;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Component
@RequiredArgsConstructor
@Slf4j
public class GeoHotelService {

    private final PartnerConfigService partnerConfigService;
    private final GeoSearchService geoSearchService;

    public GeoHotel getHotel(EPartnerId partnerId, String hotelCode) throws ExecutionException, InterruptedException {
        return geoSearchService.query(prepareGeoSearchRequest(partnerId, hotelCode))
                .thenApply(response -> {
                    if (response.getHotels().isEmpty()) {
                        return null;
                    } else {
                        return response.getHotels().get(0);
                    }
                }).get();
    }

    private GeoSearchReq prepareGeoSearchRequest(EPartnerId partnerId, String hotelCode) {
        String partnerCode = partnerConfigService.getByKey(partnerId).getCode();
        GeoHotelOriginalId geoHotelOriginalId = new GeoHotelOriginalId();
        geoHotelOriginalId.setPartnerCode(partnerCode);
        geoHotelOriginalId.setOriginalId(hotelCode);
        GeoSearchReq geoSearchReq = GeoSearchReq.byOriginalId(
                GeoOriginEnum.HOTELS_ADMINISTRATOR,
                geoHotelOriginalId,
                null
        );
        geoSearchReq.setLimit(1);
        geoSearchReq.setIncludeClosedHotels(true);
        return geoSearchReq;
    }
}
