package ru.yandex.travel.hotels.administrator.service;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class Meters {

    private final ConcurrentMap<String, Counter> errorCounterMap = new ConcurrentHashMap<>();

    public void initCounter(String tag) {
        errorCounterMap.put(tag,
                Counter.builder("skippedErrors")
                        .tag("method", tag)
                        .register(Metrics.globalRegistry));
    }

    public void incrementCounter(String tag) {
        Counter counter = errorCounterMap.get(tag);
        if (counter == null) {
            log.error("Counter {} not found", tag);
        } else {
            counter.increment();
        }
    }

}
