package ru.yandex.travel.hotels.administrator.service;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.integration.spark.SparkClient;

@Service
@RequiredArgsConstructor
public class SparkService {

    private final SparkClient sparkClient;

    public String getOgrn(String inn) {
        if (inn.length() == 12) {
            return sparkClient.getEntrepreneurShortReportSync(inn).getData().getReport().getOGRNIP();
        }
        if (inn.length() == 10) {
            return sparkClient.getCompanyShortReportSync(inn).getData().getReport().getOGRN();
        }
        throw new RuntimeException("INN length should be 10 or 12. INN: " + inn);
    }

}
