package ru.yandex.travel.hotels.administrator.service;

import java.util.List;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.hotels.administrator.entity.KnownWorkflow;
import ru.yandex.travel.hotels.administrator.entity.WorkflowEntityType;
import ru.yandex.travel.tx.utils.TransactionMandatory;
import ru.yandex.travel.workflow.EWorkflowState;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Service
@RequiredArgsConstructor
public class SupervisorService {

    private final WorkflowRepository workflowRepository;

    @TransactionMandatory
    public void ensureSupervisorsExist() {
        List<Workflow> workflowList = workflowRepository.findAllByEntityType(WorkflowEntityType.GENERIC_SUPERVISOR.getDiscriminatorValue());
        Preconditions.checkState(workflowList.size() <= 1, "There should be only 1 workflow with type: " + WorkflowEntityType.GENERIC_SUPERVISOR);
        if (workflowList.size() == 0) {
            Workflow workflow = new Workflow();
            workflow.setId(KnownWorkflow.GENERIC_SUPERVISOR.getUuid());
            workflow.setEntityType(WorkflowEntityType.GENERIC_SUPERVISOR.getDiscriminatorValue());
            workflow.setState(EWorkflowState.WS_RUNNING);
            workflowRepository.saveAndFlush(workflow);
        }
    }

}
