package ru.yandex.travel.hotels.administrator.service;

import java.util.List;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.entity.HotelConnectionUpdate;
import ru.yandex.travel.hotels.administrator.entity.LegalDetails;

@Getter
@RequiredArgsConstructor
public class UpdateResult {

    private final ResultType type;
    private final HotelConnection hotelConnection;
    private final LegalDetails oldLegalDetails;
    private final LegalDetails existingLegalDetails;
    private final LegalDetails newLegalDetails;
    private final ChangeRequisitesType changeType;
    private HotelConnectionUpdate hotelConnectionUpdate;
    private List<HotelData> boundHotels;
    private List<HotelData> relevantHotels;

    @Getter
    @RequiredArgsConstructor
    public static class HotelData {
        private final HotelConnection hotelConnection;
        private final String connectionUpdateTicket;
    }

    public static UpdateResult successResult() {
        return new UpdateResult(ResultType.SUCCESS, null, null, null, null, null);
    }

    public static UpdateResult validationRequired(HotelConnection hotelConnection,
                                                  LegalDetails oldLegalDetails,
                                                  LegalDetails existingLegalDetails,
                                                  LegalDetails newLegalDetails,
                                                  ChangeRequisitesType changeType) {
        return new UpdateResult(ResultType.VALIDATION_REQUIRED, hotelConnection, oldLegalDetails,
                existingLegalDetails, newLegalDetails, changeType);
    }

    public void setHotelConnectionUpdate(HotelConnectionUpdate hotelConnectionUpdate) {
        this.hotelConnectionUpdate = hotelConnectionUpdate;
    }

    public void setBoundHotels(List<HotelData> boundHotels) {
        this.boundHotels = boundHotels;
    }

    public void setRelevantHotels(List<HotelData> relevantHotels) {
        this.relevantHotels = relevantHotels;
    }

    public enum ResultType {
        SUCCESS,
        VALIDATION_REQUIRED
    }

    public enum ChangeRequisitesType {
        INN_CHANGE, BANK_ACCOUNT_CHANGE, OTHER_CHANGE, PAPER_AGREEMENT_CHANGE, WRONG_BIK_AND_ACCOUNT_PAIR
    }
}
