package ru.yandex.travel.hotels.administrator.service.partners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.stereotype.Service;

import ru.yandex.travel.hotels.proto.EPartnerId;

@Service
public class PartnerServiceProvider {

    private final ImmutableMap<EPartnerId, PartnerService> partnerServiceMap;

    public PartnerServiceProvider(List<PartnerService> partnerServices) {
        Map<EPartnerId, PartnerService> map = new HashMap<>();
        for (PartnerService partnerService : partnerServices) {
            if (map.containsKey(partnerService.getPartner())) {
                throw new BeanInitializationException("More than 1 service is found for partner: " + partnerService.getPartner());
            } else {
                map.put(partnerService.getPartner(), partnerService);
            }
        }
        partnerServiceMap = ImmutableMap.copyOf(map);
    }

    public PartnerService getPartnerService(EPartnerId partnerId) {
        PartnerService partnerService = partnerServiceMap.get(partnerId);
        if (partnerService == null) {
            throw new RuntimeException("Partner service was not found for partner: " + partnerId);
        }
        return partnerService;
    }

}
