package ru.yandex.travel.hotels.administrator.service.partners.mappers;

import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import ru.yandex.travel.hotels.administrator.service.partners.model.HotelDetailsDTO;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelDetails;

@Mapper(componentModel = "spring")
public interface HotelDetailsMapper {

    @Mapping(source = "hotelRef.code", target = "hotelCode")
    @Mapping(source = "addressDetails", target = "factAddress")
    @Mapping(source = "bankAccountDetails.tax", target = "bankAccountDetails.taxType")
    HotelDetailsDTO convertTravellineHotelDetails(HotelDetails hotelDetails);

    @Mapping(source = "address", target = "factAddress")
    @Mapping(source = "address.addressLine", target = "factAddress.fullAddress")
    @Mapping(source = "bankAccountDetails.tax", target = "bankAccountDetails.taxType")
    @Mapping(source = "bnovoId", target = "externalHotelId")
    @Mapping(source = "bankAccountDetails.address", target = "bankAccountDetails.addressDetails")
    @Mapping(source = "bankAccountDetails.address.addressLine", target = "bankAccountDetails.addressDetails.fullAddress")
    HotelDetailsDTO convertBnovoHotelDetails(ru.yandex.travel.hotels.common.partners.bnovo.model.HotelDetails hotelDetails);
}
