package ru.yandex.travel.hotels.administrator.task;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import ru.yandex.travel.task_processor.AbstractTaskKeyProvider;
import ru.yandex.travel.tx.utils.TransactionMandatory;

public abstract class AbstractSingletonTask extends AbstractTaskKeyProvider<String> {

    @Override
    @TransactionMandatory
    public Collection<String> getPendingTaskKeys(int maxResultSize) {
        Set<String> excludedIds = getLockedTaskKeys();
        String taskKey = getTaskKey();
        if (excludedIds.contains(taskKey)) {
            // shouldn't happen in case of a single threaded task processor
            return List.of();
        }
        return List.of(taskKey);
    }

    @Override
    @TransactionMandatory
    public long getPendingTasksCount() {
        return 1;
    }

    abstract String getTaskKey();
}
