package ru.yandex.travel.hotels.administrator.task;

import java.util.List;
import java.util.Set;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.repository.HotelConnectionRepository;
import ru.yandex.travel.hotels.administrator.service.partners.TravellineService;
import ru.yandex.travel.hotels.proto.EPartnerId;

@RequiredArgsConstructor
@Slf4j
public class TravellineConnectivityUpdateTask extends AbstractSingletonTask {
    private final static String TASK_ID = "travellineConnectivityUpdateTask";

    private final TravellineService travellineService;
    private final HotelConnectionRepository hotelConnectionRepository;

    @Override
    String getTaskKey() {
        return TASK_ID;
    }

    public void updateConnections(String taskId) {
        Preconditions.checkArgument(TASK_ID.equals(taskId));
        List<HotelConnection> connectionList = hotelConnectionRepository.findAllByPartnerId(EPartnerId.PI_TRAVELLINE);
        Set<String> activeIds = travellineService.getActiveHotelIds();
        connectionList.forEach(hc -> hc.setAvailableAtPartner(activeIds.contains(hc.hotelCode)));
    }
}
