package ru.yandex.travel.hotels.administrator.util;

import java.util.Comparator;

import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionState;

public class HotelConnectionComparator implements Comparator<HotelConnection> {

    public static final HotelConnectionComparator INSTANCE = new HotelConnectionComparator();

    private HotelConnectionComparator() {
    }

    @Override
    public int compare(HotelConnection o1, HotelConnection o2) {
        if (o1.getState() == null && o2.getState() != null) {
            return 1;
        }
        if (o1.getState() != null && o1.getState() == null) {
            return -1;
        }
        if (o1.getState() == EHotelConnectionState.CS_PUBLISHED && o2.getState() != EHotelConnectionState.CS_PUBLISHED) {
            return -1;
        }
        if (o2.getState() == EHotelConnectionState.CS_PUBLISHED && o1.getState() != EHotelConnectionState.CS_PUBLISHED) {
            return 1;
        }
        if (o1.getCreatedAt() != null && o2.getCreatedAt() == null) {
            return -1;
        }
        if (o1.getCreatedAt() == null && o2.getCreatedAt() != null) {
            return 1;
        }
        if (o1.getCreatedAt() != null && o2.getCreatedAt() != null) {
            return o1.getCreatedAt().compareTo(o2.getCreatedAt()) * -1;
        }
        return 0;
    }
}
