package ru.yandex.travel.hotels.administrator.workflow.hotelconnection;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.configuration.HotelConnectionProperties;
import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.repository.CommissionRepository;
import ru.yandex.travel.hotels.administrator.repository.ConnectionStepRepository;
import ru.yandex.travel.hotels.administrator.service.HotelConnectionService;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.hotels.administrator.service.partners.PartnerServiceProvider;
import ru.yandex.travel.hotels.administrator.workflow.hotelconnection.handlers.ManualVerificationStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.hotelconnection.handlers.NewStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.hotelconnection.handlers.PublishedStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.hotelconnection.handlers.PublishingStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.hotelconnection.handlers.UnpublishedStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionState;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(HotelConnectionProperties.class)
public class HotelConnectionWorkflowConfiguration {

    private final StarTrekService startrekService;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final WorkflowRepository workflowRepository;
    private final ConnectionStepRepository connectionStepRepository;
    private final HotelConnectionService hotelConnectionService;
    private final CommissionRepository commissionRepository;
    private final HotelConnectionProperties hotelConnectionProperties;
    private final PartnerServiceProvider partnerServiceProvider;

    @Bean
    public WorkflowEventHandler<HotelConnection> hotelConnectionWorkflowEventHandler() {
        ImmutableMap.Builder<EHotelConnectionState, StatefulWorkflowEventHandler<EHotelConnectionState,
                HotelConnection>> builder = ImmutableMap.builder();
        builder
                .put(EHotelConnectionState.CS_NEW, new NewStateHandler(partnerServiceProvider, startrekService,
                        hotelConnectionService, workflowRepository, connectionStepRepository))
                .put(EHotelConnectionState.CS_PUBLISHING, new PublishingStateHandler(workflowRepository,
                        connectionStepRepository, commissionRepository, startrekService, partnerServiceProvider,
                        hotelConnectionProperties))
                .put(EHotelConnectionState.CS_PUBLISHED, new PublishedStateHandler(hotelConnectionService,
                        partnerServiceProvider, startrekService))
                .put(EHotelConnectionState.CS_UNPUBLISHED, new UnpublishedStateHandler(partnerServiceProvider))
                .put(EHotelConnectionState.CS_MANUAL_VERIFICATION, new ManualVerificationStateHandler(partnerServiceProvider,
                        startrekService));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }

}
