package ru.yandex.travel.hotels.administrator.workflow.hotelconnection.handlers;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.service.partners.PartnerServiceProvider;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionState;
import ru.yandex.travel.hotels.administrator.workflow.proto.TNotifyConnectionStatusChanged;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@RequiredArgsConstructor
public class BaseHotelConnectionHandler extends AnnotatedStatefulWorkflowEventHandler<EHotelConnectionState,
        HotelConnection> {

    protected final PartnerServiceProvider partnerServiceProvider;

    @HandleEvent
    public void handleNotifyConnectionStatusChanged(TNotifyConnectionStatusChanged event,
                                                    StateContext<EHotelConnectionState, HotelConnection> context) {
        HotelConnection hotelConnection = context.getWorkflowEntity();
        partnerServiceProvider.getPartnerService(hotelConnection.getPartnerId()).notifyHotelStatusChanged(hotelConnection.getHotelCode());
    }

}
