package ru.yandex.travel.hotels.administrator.workflow.hotelconnection.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.administrator.entity.HotelConnection;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.hotels.administrator.service.partners.PartnerServiceProvider;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionState;
import ru.yandex.travel.hotels.administrator.workflow.proto.TActualizeHotelConnection;
import ru.yandex.travel.hotels.administrator.workflow.proto.TLegalDetailsRegistered;
import ru.yandex.travel.hotels.administrator.workflow.proto.TLegalDetailsUpdated;
import ru.yandex.travel.hotels.administrator.workflow.proto.TManualVerificationStart;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@IgnoreEvents(types = {TLegalDetailsRegistered.class, TActualizeHotelConnection.class})
public class ManualVerificationStateHandler extends BaseHotelConnectionHandler {

    private final StarTrekService starTrekService;

    public ManualVerificationStateHandler(PartnerServiceProvider partnerServiceProvider, StarTrekService starTrekService) {
        super(partnerServiceProvider);
        this.starTrekService = starTrekService;
    }

    @HandleEvent
    public void handleManualVerificationStart(TManualVerificationStart event,
                                               StateContext<EHotelConnectionState, HotelConnection> context) {
        //Notify hotel is transferred to state "Unpublished"
        HotelConnection hotelConnection = context.getWorkflowEntity();
        partnerServiceProvider.getPartnerService(hotelConnection.getPartnerId()).notifyHotelStatusChanged(hotelConnection.getHotelCode());
    }

    @HandleEvent
    public void handleLegalDetailsUpdated(TLegalDetailsUpdated event,
                                          StateContext<EHotelConnectionState, HotelConnection> context) {
        starTrekService.updateHotelConnectionTicket(context.getWorkflowEntity());
    }

}
