package ru.yandex.travel.hotels.administrator.workflow.hotelconnectionupdate;

import java.util.Collection;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import ru.yandex.travel.hotels.administrator.service.HotelConnectionUpdateService;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.AbstractTaskKeyProvider;
import ru.yandex.travel.task_processor.TaskKeyProvider;
import ru.yandex.travel.task_processor.TaskProcessor;

@Configuration
@RequiredArgsConstructor
@ConditionalOnProperty(value = "hotel-connection-update-task-processor.enabled", havingValue = "true")
@EnableConfigurationProperties({HotelConnectionUpdateTicketsTaskProcessorProperties.class})
public class HotelConnectionUpdateTaskProcessorsConfiguration {
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;

    private final HotelConnectionUpdateTicketsTaskProcessorProperties hotelConnectionUpdateTicketsTaskProcessorProperties;

    private final StarTrekService starTrekService;

    private final HotelConnectionUpdateService hotelConnectionUpdateService;

    @Bean
    public TaskProcessor<String> hotelConnectionUpdateTicketsTaskProcessor() {
        TaskKeyProvider<String> taskKeyProvider = new AbstractTaskKeyProvider<>() {
            @Override
            public Collection<String> getPendingTaskKeys(int maxResultSize) {
                return starTrekService.getHotelConnectionUpdateAutoProcessingTickets(getLockedTaskKeys(), maxResultSize);
            }

            @Override
            public long getPendingTasksCount() {
                return starTrekService.countHotelConnectionUpdateAutoProcessingTickets(getLockedTaskKeys());
            }
        };
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setName("HotelConnectionUpdate");
        transactionDefinition.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionDefinition.setIsolationLevel(TransactionDefinition.ISOLATION_REPEATABLE_READ);
        TransactionDefinition txDefinition = new DefaultTransactionDefinition(transactionDefinition);

        return new TaskProcessor<>(taskKeyProvider, hotelConnectionUpdateService::processStTicket,
                forcedRollbackTxManagerWrapper, txDefinition,
                hotelConnectionUpdateTicketsTaskProcessorProperties);
    }
}
