package ru.yandex.travel.hotels.administrator.workflow.hotelconnectionupdate;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.configuration.HotelConnectionProperties;
import ru.yandex.travel.hotels.administrator.entity.HotelConnectionUpdate;
import ru.yandex.travel.hotels.administrator.service.HotelConnectionService;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.hotels.administrator.workflow.hotelconnectionupdate.handlers.NewStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.hotelconnectionupdate.handlers.ProcessingStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionUpdateState;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(HotelConnectionProperties.class)
public class HotelConnectionUpdateWorkflowConfiguration {

    private final StarTrekService startrekService;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final HotelConnectionService hotelConnectionService;

    @Bean
    public WorkflowEventHandler<HotelConnectionUpdate> hotelConnectionUpdateWorkflowEventHandler() {
        ImmutableMap.Builder<EHotelConnectionUpdateState, StatefulWorkflowEventHandler<EHotelConnectionUpdateState,
                HotelConnectionUpdate>> builder = ImmutableMap.builder();
        builder
                .put(EHotelConnectionUpdateState.HCU_NEW, new NewStateHandler(startrekService, hotelConnectionService))
                .put(EHotelConnectionUpdateState.HCU_PROCESSING, new ProcessingStateHandler(startrekService));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }

}
