package ru.yandex.travel.hotels.administrator.workflow.legaldetails;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.entity.LegalDetails;
import ru.yandex.travel.hotels.administrator.repository.ConnectionStepRepository;
import ru.yandex.travel.hotels.administrator.repository.HotelConnectionUpdateRepository;
import ru.yandex.travel.hotels.administrator.service.LegalDetailsService;
import ru.yandex.travel.hotels.administrator.service.SparkService;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.hotels.administrator.workflow.legaldetails.handlers.DeactivatedStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.legaldetails.handlers.DeactivatingStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.legaldetails.handlers.ManualVerificationStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.legaldetails.handlers.NewStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.legaldetails.handlers.RegisteredStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.legaldetails.handlers.RegisteringStateHandler;
import ru.yandex.travel.hotels.administrator.workflow.proto.ELegalDetailsState;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Configuration
@RequiredArgsConstructor
public class LegalDetailsWorkflowConfiguration {

    private final StarTrekService startrekService;
    private final LegalDetailsService legalDetailsService;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final WorkflowRepository workflowRepository;
    private final ConnectionStepRepository connectionStepRepository;
    private final SparkService sparkService;
    private final HotelConnectionUpdateRepository hotelConnectionUpdateRepository;

    @Bean
    public WorkflowEventHandler<LegalDetails> legalDetailsWorkflowEventHandler() {
        ImmutableMap.Builder<ELegalDetailsState, StatefulWorkflowEventHandler<ELegalDetailsState,
                LegalDetails>> builder = ImmutableMap.builder();
        builder
                .put(ELegalDetailsState.DS_NEW, new NewStateHandler(startrekService, sparkService))
                .put(ELegalDetailsState.DS_REGISTERING, new RegisteringStateHandler(workflowRepository,
                        connectionStepRepository, startrekService, legalDetailsService, hotelConnectionUpdateRepository))
                .put(ELegalDetailsState.DS_REGISTERED, new RegisteredStateHandler(startrekService,
                        legalDetailsService, connectionStepRepository, workflowRepository))
                .put(ELegalDetailsState.DS_DEACTIVATING, new DeactivatingStateHandler(startrekService))
                .put(ELegalDetailsState.DS_DEACTIVATED, new DeactivatedStateHandler(startrekService))
                .put(ELegalDetailsState.DS_MANUAL_VERIFICATION, new ManualVerificationStateHandler(startrekService));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }

}
