package ru.yandex.travel.hotels.administrator.workflow.legaldetails.handlers;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.administrator.entity.LegalDetails;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.hotels.administrator.workflow.proto.ELegalDetailsState;
import ru.yandex.travel.hotels.administrator.workflow.proto.TBindHotelToLegalDetails;
import ru.yandex.travel.hotels.administrator.workflow.proto.TRegisterLegalDetails;
import ru.yandex.travel.hotels.administrator.workflow.proto.TUpdateLegalDetails;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@RequiredArgsConstructor
@IgnoreEvents(types = {TRegisterLegalDetails.class, TUpdateLegalDetails.class,})
public class ManualVerificationStateHandler extends AnnotatedStatefulWorkflowEventHandler<ELegalDetailsState, LegalDetails> {

    private final StarTrekService starTrekService;

    @HandleEvent
    public void handleBindHotelToLegalDetails(TBindHotelToLegalDetails event,
                                              StateContext<ELegalDetailsState, LegalDetails> context) {
        LegalDetails legalDetails = context.getWorkflowEntity();
        if (legalDetails.getStTicket() != null) {
            starTrekService.linkTickets(legalDetails.getStTicket(), event.getHotelConnectionStTicket());
        }

    }
}
