package ru.yandex.travel.hotels.administrator.workflow.legaldetails.handlers;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.administrator.entity.LegalDetails;
import ru.yandex.travel.hotels.administrator.service.SparkService;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.hotels.administrator.workflow.proto.ELegalDetailsState;
import ru.yandex.travel.hotels.administrator.workflow.proto.TBindHotelToLegalDetails;
import ru.yandex.travel.hotels.administrator.workflow.proto.TRegisterLegalDetails;
import ru.yandex.travel.hotels.administrator.workflow.proto.TRegisteringStart;
import ru.yandex.travel.hotels.administrator.workflow.proto.TUpdateLegalDetails;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@RequiredArgsConstructor
public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<ELegalDetailsState, LegalDetails> {

    private final StarTrekService starTrekService;

    private final SparkService sparkService;

    @HandleEvent
    public void handleRegisterLegalDetails(TRegisterLegalDetails event,
                                           StateContext<ELegalDetailsState, LegalDetails> context) {
        LegalDetails legalDetails = context.getWorkflowEntity();
        legalDetails.setStTicket(starTrekService.createOrUpdateLegalDetailsTicket(legalDetails));
        context.scheduleEvent(TUpdateLegalDetails.newBuilder().build());
    }

    @HandleEvent
    public void handleUpdateLegalDetails(TUpdateLegalDetails event, StateContext<ELegalDetailsState, LegalDetails> context) {
        LegalDetails legalDetails = context.getWorkflowEntity();
        legalDetails.setOgrn(sparkService.getOgrn(legalDetails.getInn()));
        legalDetails.setStTicket(starTrekService.createOrUpdateLegalDetailsTicket(legalDetails));
        legalDetails.setState(ELegalDetailsState.DS_REGISTERING);
        context.scheduleEvent(TRegisteringStart.newBuilder().build());
    }


    @HandleEvent
    public void handleBindHotelToLegalDetails(TBindHotelToLegalDetails event,
                                              StateContext<ELegalDetailsState, LegalDetails> context) {
        LegalDetails legalDetails = context.getWorkflowEntity();
        starTrekService.linkTickets(legalDetails.getStTicket(), event.getHotelConnectionStTicket());

    }
}
