package ru.yandex.travel.hotels.administrator.workflow.supervisor;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.administrator.configuration.StarTrekConfigurationProperties;
import ru.yandex.travel.hotels.administrator.repository.BillingRegistrationRepository;
import ru.yandex.travel.hotels.administrator.repository.HotelConnectionRepository;
import ru.yandex.travel.hotels.administrator.repository.HotelConnectionUpdateRepository;
import ru.yandex.travel.hotels.administrator.repository.LegalDetailsRepository;
import ru.yandex.travel.hotels.administrator.repository.TicketRepository;
import ru.yandex.travel.hotels.administrator.service.Meters;
import ru.yandex.travel.hotels.administrator.service.TemplateService;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.repository.WorkflowEventRepository;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Configuration
@RequiredArgsConstructor
public class GenericSupervisorWorkflowConfiguration {

    private final TicketRepository ticketRepository;
    private final WorkflowRepository workflowRepository;
    private final WorkflowEventRepository eventRepository;
    private final StarTrekConfigurationProperties properties;
    private final TemplateService templateService;
    private final HotelConnectionRepository hotelConnectionRepository;
    private final HotelConnectionUpdateRepository hotelConnectionUpdateRepository;
    private final LegalDetailsRepository legalDetailsRepository;
    private final Meters meters;
    private final BillingRegistrationRepository billingRegistrationRepository;

    @Bean
    public WorkflowEventHandler genericErrorSupervisorWorkflowEventHandler() {
        return new GenericSupervisorWorkflowEventHandler(ticketRepository, workflowRepository, eventRepository, meters,
                properties, templateService, hotelConnectionRepository, hotelConnectionUpdateRepository, legalDetailsRepository,
                billingRegistrationRepository);
    }
}
