package ru.yandex.travel.hotels.administrator.workflow.supervisor;

import java.util.Comparator;
import java.util.Optional;

import ru.yandex.travel.commons.proto.TError;
import ru.yandex.travel.workflow.EWorkflowState;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.entities.WorkflowStateTransition;

public class SupervisorUtils {

    public static String extractException(Workflow workflow) {
        StringBuilder builder = new StringBuilder();
        Optional<WorkflowStateTransition> optionalTransition = workflow.getStateTransitions().stream()
                .filter(transition -> EWorkflowState.WS_CRASHED.equals(transition.getToState()))
                .max(Comparator.comparing(WorkflowStateTransition::getCreatedAt));
        if (optionalTransition.isPresent()) {
            builder.append(extractException((TError) optionalTransition.get().getData()));
        } else {
            builder.append("Нет информации об исключении.");
        }
        return builder.toString();
    }

    public static String extractException(TError error) {
        StringBuilder builder = new StringBuilder();
        builder.append("Исключение: ").append(error.getCode()).append(": ").append(error.getMessage()).append(
                "\n");
        prepareStacktrace(builder, error, 0);
        builder.append("\n").append("\n");
        return builder.toString();
    }

    private static void prepareStacktrace(StringBuilder trace, TError error, int depth) {
        String tab = new String(new char[depth * 2]).replace('\0', ' ');
        trace.append(tab).append(error.getCode()).append(": ").append(error.getMessage()).append("\n");
        if (error.getAttributeMap().containsKey("class")) {
            trace.append(tab).append("class: ")
                    .append(error.getAttributeMap().get("class"));
        }
        if (error.getAttributeMap().containsKey("stack_trace")) {
            trace.append("%%").append(tab).append("stack_trace: ")
                    .append(error.getAttributeMap().get("stack_trace"))
                    .append("%%");
        }
        trace.append("----");
        for (String key : error.getAttributeMap().keySet()) {
            if (!"class".equals(key) && !"stack_trace".equals(key)) {
                trace
                        .append(tab).append(key).append(": ")
                        .append(tab).append(error.getAttributeMap().get(key)).append("\n");
            }
        }
        for (TError nestedError : error.getNestedErrorList()) {
            prepareStacktrace(trace, nestedError, depth + 1);
        }
    }
}
