package ru.yandex.travel.hotels.administrator.workflow.ticket;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.travel.hotels.administrator.entity.Ticket;
import ru.yandex.travel.hotels.administrator.service.Meters;
import ru.yandex.travel.hotels.administrator.service.StarTrekService;
import ru.yandex.travel.hotels.administrator.workflow.proto.ETicketState;
import ru.yandex.travel.hotels.administrator.workflow.proto.TCreateIssue;
import ru.yandex.travel.workflow.MessagingContext;
import ru.yandex.travel.workflow.base.AnnotatedWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Component
@Slf4j
public class TicketWorkflowHandler extends AnnotatedWorkflowEventHandler<Ticket> {

    private static final String ERROR_COUNTER_TAG = "TicketCreateWorkflow";

    private final StarTrekService starTrekService;
    private final Meters meters;

    public TicketWorkflowHandler(StarTrekService starTrekService, Meters meters) {
        this.starTrekService = starTrekService;
        this.meters = meters;
        this.meters.initCounter(ERROR_COUNTER_TAG);
    }

    @HandleEvent
    public void handleCreateIssue(TCreateIssue event, MessagingContext<Ticket> context) {
        try {
            Ticket ticket = context.getWorkflowEntity();
            Preconditions.checkState(ticket.getState().equals(ETicketState.TS_NEW),
                    "Unexpected ticket state: %s", ticket.getState());
            String issueId = starTrekService.createIssueForGenericWorkflowError(event.getTicketTitle(),
                    event.getTicketDescription());
            ticket.setIssueId(issueId);
            ticket.setState(ETicketState.TS_CREATED);
        } catch (Exception e) {
            meters.incrementCounter(ERROR_COUNTER_TAG);
            throw e;
        }
    }
}
