create table legal_details_updates
(
    id                              bigint          not null,
    hotel_connection_id             uuid            not null,
    legal_details_id                uuid            not null,

    inn                             varchar(128)    not null,
    kpp                             varchar(128)    not null,
    bic                             varchar(128)    not null,
    payment_account                 varchar(128)    not null,
    legal_name                      varchar(256),
    legal_post_code                 varchar(16),
    legal_address                   varchar(256),
    post_code                       varchar(16),
    post_address                    varchar(256),
    phone                           varchar(64),
    accountant_email                varchar(256),

    state                           varchar(64)     not null,
    created_at                      timestamp,
    updated_at                      timestamp,
    last_transition_at              timestamp,
    version                         int,

    primary key(id),
    foreign key(hotel_connection_id)    references hotel_connections(id),
    foreign key(legal_details_id)       references legal_details(id)
);

create sequence legal_details_updates_id_seq;

create index legal_details_updates_legal_details_id_state_idx on legal_details_updates(legal_details_id, state);
