-- auto-generated definition
create table workflows
(
    id                          uuid not null
        constraint workflows_pkey
            primary key,
    entity_id                   uuid,
    entity_type                 varchar(256),
    created_at                  timestamp,
    updated_at                  timestamp,
    next_reservation_refresh_at timestamp,
    version                     integer,
    sleep_till                  timestamp,
    supervisor_id               uuid,
    state                       integer
);

create index workflow_state_idx
    on workflows (state);

create index workflow_sleep_till_idx
    on workflows (sleep_till);

create index workflows_state_idx
    on workflows (state);

-- ==================================
create sequence workflow_state_transitions_id_seq;

-- ======================================
create table entity_state_transitions (
                                          id bigint,
                                          workflow_id UUID,
                                          entity_id UUID,
                                          entity_type varchar(256),
                                          from_state int,
                                          previous_transition_at timestamp,
                                          to_state int,
                                          transition_at timestamp,
                                          primary key(id)
);

create sequence entity_state_transition_id_seq;
create index es_transitions_wf_id_idx on entity_state_transitions(workflow_id);
create index es_transitions_entity_id_idx on entity_state_transitions(entity_id);

-- ==================================
create table workflow_events
(
    id           bigint not null
        constraint workflow_events_pkey
            primary key,
    workflow_id  uuid,
    created_at   timestamp,
    class_name   varchar(512),
    data         bytea,
    times_tried  integer default 0,
    state        integer,
    processed_at timestamp
);

create index workflow_events_state_idx
    on workflow_events (state);

create index workflow_events_workflow_idx
    on workflow_events (workflow_id);

create sequence workflow_events_id_seq start with 1000;

-- ======================================
create table workflow_state_transitions
(
    id                   bigint not null
        constraint workflow_state_transitions_pkey
            primary key,
    workflow_id          uuid
        constraint workflow_state_transitions_workflow_id_fkey
            references workflows,
    created_at           timestamp,
    transition_order_num integer,
    data_class_name      varchar(1024),
    data                 bytea,
    from_state           integer,
    to_state             integer
);
