create table hotel_connections
(
    id                       uuid         not null
        constraint hotel_connections_pkey primary key,
    hotel_code               varchar(128) not null,
    partner_id               integer      not null,
    hotel_name               varchar(256),
    permalink                bigint,
    st_ticket                varchar(128),
    ready_to_publish         boolean      not null,
    legal_details_id         uuid,
    ready_for_orchestrator   boolean      not null,
    ready_for_offercache     boolean      not null,
    clustering_verified      boolean      not null,
    commissions_added        boolean      not null,
    oc_wl_updated            boolean      not null,
    legal_details_registered boolean      not null,

    workflow_id              uuid,
    state                    integer      not null,
    created_at               timestamp,
    updated_at               timestamp,
    last_transition_at       timestamp,

    constraint hotel_connections_unique unique (hotel_code, partner_id)
);

create table legal_details
(
    id                             uuid         not null
        constraint legal_details_pkey primary key,
    inn                            varchar(128) not null,
    kpp                            varchar(128) not null,
    bic                            varchar(128) not null,
    payment_account                varchar(128) not null,
    legal_name                     varchar(256),
    legal_address                  varchar(256),
    blocked_by_yandex              boolean      not null,
    offer_accepted                 boolean      not null,
    st_ticket                      varchar(128),
    balance_client_id              bigint,
    balance_contract_id            varchar(128),
    billing_partner_config_updated boolean      not null,
    registered_in_balance          boolean      not null,

    workflow_id                    uuid,
    state                          integer      not null,
    created_at                     timestamp,
    updated_at                     timestamp,
    last_transition_at             timestamp,
    version                        int,
    constraint legal_details_unique unique (inn, kpp, bic, payment_account)
)
