create table billing_registrations(
    id                      uuid        not null,
    state                   int         not null,
    workflow_id             uuid        not null,
    parent_workflow_id      uuid        not null,
    legal_details_id        uuid        not null,
    client_id               bigint,
    person_id               bigint,
    contract_id             bigint,
    external_contract_id    varchar(64),
    created_at              timestamp   not null,
    updated_at              timestamp   not null,
    registered_at           timestamp,
    last_transition_at      timestamp,
    version                 int         not null,

    primary key(id),
    unique(legal_details_id),
    foreign key(workflow_id) references workflows(id),
    foreign key(parent_workflow_id) references workflows(id),
    foreign key(legal_details_id) references legal_details(id)
);
