CREATE OR REPLACE FUNCTION restore_registration_after_create_person_failed(hotelConnectionId uuid) RETURNS varchar AS
$$
    /*
     Перед запуском данной функции обновите все поля в сущности LegalDetails в соответствии с данными, приходящими из
     /hotel_details партнера

     Функция проверяет, что флоу регистрации действительно упал при создании объекта Person, после чего восстанавливает
     воркфлоу и эвент по созданию Person
     */
DECLARE
    legalDetailsId                   uuid;
    billingRegistrationId            uuid;
    billingRegistrationState         int;
    billingRegistrationWorkflowId    uuid;
    billingRegistrationWorkflowState int;
    billingEventClassName            varchar;
    billingEventState                int;
    billingEventId                   bigint;


BEGIN
    SELECT legal_details_id INTO STRICT legalDetailsId FROM hotel_connections WHERE id = hotelConnectionId;
    RAISE NOTICE 'legalDetailsId = %', legalDetailsId;
    SELECT id INTO STRICT billingRegistrationId FROM billing_registrations WHERE legal_details_id = legalDetailsId;
    RAISE NOTICE 'billingRegistrationId = %', billingRegistrationId;
    SELECT state INTO STRICT billingRegistrationState FROM billing_registrations WHERE id = billingRegistrationId;
    RAISE NOTICE 'billingRegistrationState = %', billingRegistrationState;
    SELECT workflow_id INTO STRICT billingRegistrationWorkflowId FROM billing_registrations WHERE id = billingRegistrationId;
    SELECT state INTO STRICT billingRegistrationWorkflowState FROM workflows WHERE id = billingRegistrationWorkflowId;

    SELECT class_name, state, id
    INTO STRICT billingEventClassName, billingEventState, billingEventId
    FROM workflow_events
    WHERE workflow_id = billingRegistrationWorkflowId
    ORDER BY created_at DESC
    LIMIT 1;

    RAISE NOTICE 'billingRegistrationState = %', billingRegistrationState;
    RAISE NOTICE 'billingRegistrationWorkflowState = %', billingRegistrationWorkflowState;
    RAISE NOTICE 'billingEventClassName = %', billingEventClassName;
    RAISE NOTICE 'billingEventState = %', billingEventState;

    assert billingRegistrationState = 3; -- BRS_CREATING_PERSON
    assert billingRegistrationWorkflowState = 4; -- WS_CRASHED
    assert billingEventClassName =
           'ru.yandex.travel.hotels.administrator.workflow.proto.TBillingRegistrationCreatePerson';
    assert billingEventState = 3;
    -- WES_CRASHED

    -- restore billingRegistration workflow
    UPDATE workflows
    SET state = 1
    WHERE id = billingRegistrationWorkflowId;

    -- restore billingEvent to New
    UPDATE workflow_events
    SET state = 1
    WHERE id = billingEventId;

    RETURN 'Флоу регистрации юр. лица в балансе восстановлен';
END;
$$ LANGUAGE plpgsql;
