create table hotel_connection_updates
(
    id                              uuid                  not null
        constraint hotel_connection_updates_pkey primary key,
--     hotel_connection_update fields
    st_ticket                       varchar(128),
    financial_events_updated        boolean               not null,
    legal_details_published         boolean               not null,

--     hotel_connection fields
    hotel_connection_id             uuid                  not null,
    hotel_code                      varchar(128)          not null,
    partner_id                      integer               not null,
    original_hotel_connection_state integer               not null,
    accountant_email                varchar(256),
    reservation_phone               varchar(128),
    address                         varchar(256),
    contract_person_name            varchar(256),
    contract_person_position        varchar(256),
    contract_person_phone           varchar(128),
    city_name                       varchar(128),
    contract_person_email           varchar(256),
    hotel_details_dto               jsonb,

--     legal_details fields
    vat_type                        integer,
    tax_type                        varchar(64),
    inn                             varchar(128)          not null,
    kpp                             varchar(128),
    bic                             varchar(128)          not null,
    payment_account                 varchar(128)          not null,
    bank_name                       varchar(256),
    corresponding_account           varchar(256),
    legal_name                      varchar(256),
    full_legal_name                 varchar(512),
    legal_post_code                 varchar(16),
    legal_address                   varchar(256),
    original_legal_address          varchar(256),
    legal_address_unified           boolean default false not null,
    post_code                       varchar(16),
    post_address                    varchar(256),
    offer_accepted                  boolean               not null,
    legal_phone                     varchar(64),

    workflow_id                     uuid,
    state                           integer               not null,
    created_at                      timestamp,
    updated_at                      timestamp,
    last_transition_at              timestamp
);
