-- datalens "Подключенные отели", tab "Подключенные отели"
-- https://datalens.yandex-team.ru/8sq494vvm2qw4-podklyuchennye-oteli?state=7ab193fa140
create or replace view hotel_connection_view
as
SELECT hc.hotel_code,
       CASE
           WHEN hc.partner_id = 13 THEN 'Travelline'::text
           WHEN hc.partner_id = 45 THEN 'Bnovo'::text
           ELSE NULL::text
           END                                                  AS partner_id,
       hc.hotel_name,
       hc.permalink,
       'https://st.yandex-team.ru/'::text || hc.st_ticket::text AS st_ticket,
       CASE
           WHEN hc.state = 1 THEN 'New'::text
           WHEN hc.state = 2 THEN 'Publishing'::text
           WHEN hc.state = 3 THEN 'Published'::text
           WHEN hc.state = 4 THEN 'Unpublishing'::text
           WHEN hc.state = 5 THEN 'Unpublished'::text
           WHEN hc.state = 6 THEN 'Manual Verification'::text
           ELSE NULL::text
           END                                                  AS state,
       hc.created_at + '03:00:00'::interval                     AS created_at,
       hc.accountant_email,
       ld.inn,
       ld.kpp,
       ld.bic,
       ld.payment_account,
       ld.legal_name,
       ld.legal_address,
       ld.balance_client_id,
       ld.balance_contract_id,
       ld.post_address,
       ld.phone,
       ld.tax_type,
       hc.reservation_phone,
       hc.address,
       hc.city_name,
       hc.contract_person_name,
       hc.contract_person_position,
       hc.contract_person_email,
       hc.contract_person_phone,
       ld.full_legal_name,
       'https://admin.balance.yandex.ru/tclient.xml?tcl_id='::text ||
       ld.balance_client_id                                     AS balance_client_link,
       'https://admin.balance.yandex.ru/contract.xml?contract_id='::text ||
       ld.balance_contract_id                                   AS balance_contract_link,
       'https://admin.balance.yandex.ru/subpersons.xml?tcl_id='::text ||
       ld.balance_client_id                                     AS balance_payer_link,
       CASE
           WHEN hc.unpublished_reason::text = 'apartments'::text THEN 'Это апартаменты'::text
           WHEN hc.unpublished_reason::text = 'agency'::text THEN 'Это агентство'::text
           WHEN hc.unpublished_reason::text = 'additional services'::text THEN 'Это доп. услуги'::text
           WHEN hc.unpublished_reason::text = 'hotel initiative'::text THEN 'Отключен по инициативе отеля'::text
           WHEN hc.unpublished_reason::text = 'other'::text THEN 'Другая причина'::text
           ELSE NULL::text
           END                                                  AS unpublished_reason,
       br.external_contract_id,
       hc.external_hotel_id
FROM hotel_connections hc
         LEFT JOIN legal_details ld ON hc.legal_details_id = ld.id
         LEFT JOIN billing_registrations br ON br.legal_details_id = ld.id;

alter table hotel_connection_view
    owner to hotels_admin;

grant select on hotel_connection_view to administrator_analytics;

