RECURSE(
    src/test
)

JAVA_PROGRAM(hotels-administrator)

JDK_VERSION(11)
WITH_KOTLIN()

INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel-hotels)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

EXCLUDE(
    # replaced by org.dom4j
    contrib/java/dom4j/dom4j

    # broken dependencies from st client
    contrib/java/ru/yandex/iceberg-bolts
    contrib/java/ru/yandex/iceberg-misc
)

PEERDIR(
    travel/library/java/spring-boot-skeleton
    travel/library/java/hibernate-commons
    travel/library/java/workflow
    travel/library/java/balance-client
    travel/library/java/spark-client
    travel/library/java/yt-lucene-index
    travel/library/java/yt-utils

    travel/hotels/lib/java/partner_config
    travel/hotels/lib/java/geosearch
    travel/hotels/lib/java/partner_parsers
    travel/hotels/hotels_administrator/proto

    sprav/protos
    tracker/tracker-java-client/tracker-client/src/main

    contrib/java/org/springframework/boot/spring-boot-starter-data-jpa
    contrib/java/org/springframework/boot/spring-boot-starter-validation
    contrib/java/com/mitchellbosecke/pebble/2.4.0
    contrib/java/org/asynchttpclient/async-http-client
    contrib/java/org/apache/logging/log4j/log4j-jcl
    contrib/java/org/flywaydb/flyway-core
    contrib/java/org/hibernate/hibernate-envers

    contrib/java/com/h2database/h2
    contrib/java/org/postgresql/postgresql
    contrib/java/javax/xml/bind/jaxb-api/2.3.0
    contrib/java/com/sun/xml/bind/jaxb-impl/2.3.0
    contrib/java/com/sun/xml/bind/jaxb-core/2.3.0

    contrib/java/org/mapstruct/mapstruct
    contrib/java/org/mapstruct/mapstruct-processor

    contrib/java/org/jetbrains/kotlin/kotlin-reflect
)

ANNOTATION_PROCESSOR(
    org.mapstruct.ap.MappingProcessor
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/hotels-administrator.py
    CUSTOM_PROPERTY appName hotels-administrator
    CUSTOM_PROPERTY mainClass ru.yandex.travel.hotels.administrator.AdministratorApplication
)

LINT(base)
END()
