# coding: utf8
from __future__ import print_function

import argparse
import logging
import sys


from travel.hotels.hotels_administrator.tools.administrator_cli.admin_internal_api import (
    PARTNER_IDS, HOTEL_CONN_STATES, UNPUBLISHED_REASONS,
    handle_createLegalDetails, handle_updateLegalDetails, handle_changeHotelConnectionStatus, handle_acceptConnectionUpdate,
    handle_rejectConnectionUpdate
)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-v", "--verbose", action="store_true", default=False)
    parser.add_argument('--env', choices=['prod', 'testing', 'dev'], required=True)
    parser.add_argument("--host")
    parser.add_argument("--port", default=29855)
    parser.add_argument("--timeout", default=10, type=int)
    parser.add_argument("--tvm-client-id", default=2021364, type=int)
    parser.add_argument("--tvm-client-secret")
    subparsers = parser.add_subparsers()

    createLegalDetails_parser = subparsers.add_parser("createLegalDetails")
    createLegalDetails_parser.set_defaults(func=handle_createLegalDetails)
    createLegalDetails_parser.add_argument("--partner-id", choices=PARTNER_IDS)
    createLegalDetails_parser.add_argument("--client-id", type=int)
    createLegalDetails_parser.add_argument("--contract-id", type=int)
    createLegalDetails_parser.add_argument("--person-id", type=int)

    updateLegalDetails_parser = subparsers.add_parser("updateLegalDetails")
    updateLegalDetails_parser.set_defaults(func=handle_updateLegalDetails)
    updateLegalDetails_parser.add_argument("--legal-details-id")

    changeConnectionStatus_parser = subparsers.add_parser("changeConnectionStatus")
    changeConnectionStatus_parser.set_defaults(func=handle_changeHotelConnectionStatus)
    changeConnectionStatus_parser.add_argument("--hotel-code")
    changeConnectionStatus_parser.add_argument("--partner-id", choices=PARTNER_IDS)
    changeConnectionStatus_parser.add_argument("--connection-state", choices=HOTEL_CONN_STATES)
    changeConnectionStatus_parser.add_argument("--unpublished-reason", choices=UNPUBLISHED_REASONS, required=False)

    acceptConnectionUpdate_parser = subparsers.add_parser("acceptConnectionUpdate")
    acceptConnectionUpdate_parser.set_defaults(func=handle_acceptConnectionUpdate)
    acceptConnectionUpdate_parser.add_argument("--connection-update-id", required=True)
    acceptConnectionUpdate_parser.add_argument("--bank-change-mode", default='change_inplace',
                                               choices=['create_new', 'change_inplace'])

    rejectConnectionUpdate_parser = subparsers.add_parser("rejectConnectionUpdate")
    rejectConnectionUpdate_parser.set_defaults(func=handle_rejectConnectionUpdate)
    rejectConnectionUpdate_parser.add_argument("--connection-update-id", required=True)

    args = parser.parse_args()
    logging.basicConfig(level=(logging.DEBUG if args.verbose else logging.INFO),
                        format="%(asctime)-15s | %(levelname)s | %(message)s",
                        stream=sys.stdout)

    args.func(args)


if __name__ == "__main__":
    main()
