# coding: utf8
from __future__ import print_function

import argparse
import logging
import travel.hotels.hotels_administrator.proto.admin_service_pb2 as admin_service_pb2
import travel.hotels.hotels_administrator.proto.admin_service_pb2_grpc as admin_service_pb2_grpc
import travel.hotels.hotels_administrator.proto.hotel_connection_workflow_pb2 as hotel_connection_workflow_pb2
import travel.hotels.proto2.hotels_pb2 as hotels_pb2
from google.protobuf import text_format

from travel.hotels.hotels_administrator.tools.administrator_cli.grpc_client import create_grpc_channel

PARTNER_IDS = [partner for partner in hotels_pb2.EPartnerId.keys()]
HOTEL_CONN_STATES = [state for state in hotel_connection_workflow_pb2.EHotelConnectionState.keys()]
UNPUBLISHED_REASONS = [reason for reason in admin_service_pb2.EInternalUnpublishedReason.keys()]


def protobuf_to_string(message):
    return text_format.MessageToString(message, as_utf8=True)


def call_hotel_admin_internal(args_or_channel, handler, req):
    if isinstance(args_or_channel, argparse.Namespace):
        channel = create_grpc_channel(args_or_channel)
    else:
        channel = args_or_channel

    with channel:
        stub = admin_service_pb2_grpc.AdministratorAdminServiceInterfaceStub(channel)
        rsp = getattr(stub, handler)(req)
    logging.info("Received response: \n%s", protobuf_to_string(rsp))
    return rsp


def handle_createLegalDetails(args):
    create_legal_details_req = admin_service_pb2.TCreateLegalDetailsReq(
        PartnerId=args.partner_id,
        BillingClientId=args.client_id,
        BillingContractId=args.contract_id,
        BillingPersonId=args.person_id
    )
    return call_hotel_admin_internal(args, 'CreateLegalDetailsFromBalance', create_legal_details_req)


def handle_updateLegalDetails(args):
    update_legal_details_req = admin_service_pb2.TUpdateLegalDetailsReq(
        Id=args.legal_details_id
    )
    return call_hotel_admin_internal(args, 'UpdateLegalDetailsFromBalance', update_legal_details_req)


def handle_changeHotelConnectionStatus(args):
    change_connection_status_req = admin_service_pb2.TChangeHotelConnectionStatusReq(
        HotelCode=args.hotel_code,
        PartnerId=args.partner_id,
        ConnectionState=args.connection_state,
        UnpublishedReason=args.unpublished_reason
    )
    return call_hotel_admin_internal(args, 'ChangeHotelConnectionStatus', change_connection_status_req)


def handle_acceptConnectionUpdate(args):
    change_inplace = args.bank_change_mode == 'change_inplace'
    accept_connection_update_req = admin_service_pb2.TAcceptConnectionUpdateReq(
        UpdateId=args.connection_update_id,
        BankChangeInplaceMode=change_inplace
    )
    return call_hotel_admin_internal(args, 'AcceptHotelConnectionUpdate', accept_connection_update_req)


def handle_rejectConnectionUpdate(args):
    reject_connection_update_req = admin_service_pb2.TRejectConnectionUpdateReq(
        UpdateId=args.connection_update_id
    )
    return call_hotel_admin_internal(args, 'RejectHotelConnectionUpdate', reject_connection_update_req)
