# coding: utf8
from __future__ import print_function

"""
WIP.
Not a working CLI, but examples of admin partner API calling are working
"""

import logging

from google.protobuf import text_format

import travel.hotels.hotels_administrator.proto.hotel_administrator_pb2 as hotel_admin_pb2
import travel.hotels.hotels_administrator.proto.hotel_administrator_pb2_grpc as hotel_administrator_pb2_grpc

from travel.hotels.hotels_administrator.tools.administrator_cli.grpc_client import create_grpc_channel


TRAVELLINE_ID = 13


def protobuf_to_string(message):
    return text_format.MessageToString(message, as_utf8=True)


def call_hotel_admin(args, handler, req):
    with create_grpc_channel(args) as channel:
        stub = hotel_administrator_pb2_grpc.AdministratorInterfaceStub(channel)
        rsp = getattr(stub, handler)(req)
    logging.info("Received response: \n%s", protobuf_to_string(rsp))
    return rsp


def handle_hotelStatus(args):
    return call_hotel_admin(args, 'HotelStatus', hotel_admin_pb2.THotelStatusReq(
        PartnerId=TRAVELLINE_ID,
        HotelCode="83",
    ))


def handle_hotelStatusByPermalink(args):
    return call_hotel_admin(args, 'HotelStatusByPermalink', hotel_admin_pb2.THotelStatusByPermalinkReq(
        Permalink=1389337856
    ))


def handle_hotelDetailsChanged(args):
    return call_hotel_admin(args, 'HotelDetailsChanged', hotel_admin_pb2.THotelDetailsChangedReq(
        PartnerId=TRAVELLINE_ID,
        HotelCode="83",
    ))


def handle_acceptAgreement(args):
    return call_hotel_admin(args, 'AcceptAgreement', hotel_admin_pb2.TAcceptAgreementReq(
        PartnerId=TRAVELLINE_ID,
        HotelCode="83",
        Inn="7806396022",
        ContactName="Славецкий Андрей Владимирович",
        ContactPosition="Генеральный директор",
        ContactPhone="7(495)641 10 00",
        ContactEmail="sales@astrus.ru",
    ))
