# coding: utf8
from flask import Flask, request, jsonify
import requests

app = Flask(__name__)


@app.route('/hotel_details')
def hotel_details():
    hotel_code = request.args.get('hotel.code')
    # Аструс
    if hotel_code == '830303':
        response = {
            "hotel_details": {
                "hotel_ref": {
                    "code": "830303"
                },
                "address_details": {
                    "full_address": "190031, г. Санкт-Петербург, Санкт-Петербург, наб.реки Фонтанки, д. 97",
                    "city_name": "Санкт-Петербург",
                    "postal_code": "190031",
                    "region": "г. Санкт-Петербург",
                },
                "contact_info": [
                    {
                        "name": "Славецкий Андрей Владимирович",
                        "position": "Генеральный директор",
                        "phone": "7(495)641 10 00",
                        "email": "sales@astrus.ru",
                        "contact_type": "contract"
                    },
                    {
                        "email": "new-email@test.test",
                        "contact_type": "accountant"
                    },
                    {
                        "contact_type": "reservation",
                        "phone": "+79216411611"
                    }
                ],
                "bank_account_details": {
                    "person_legal_name": "АО \"ЦДТ на Ленинском\"",
                    "country": "Российская Федерация",
                    "address_details": {
                        "postal_code": "119526",
                        "country": "Российская Федерация",
                        "full_address": "119526, Питер, Ленинский проспект д.146"
                    },
                    "phone": "7(495)641 10 00 123",
                    "inn": "7806396022",
                    "kpp": "772901001",
                    "bank_name": "АО \"Райффайзенбанк\"",
                    "bic": "044525700",
                    "corresponding_account": "30101810200000000700",
                    "current_account": "40702810500000059043",
                    "tax": "simple_income",
                },
                "offer_status": "accepted",
                "offer_updated_at": "2020-02-25 15:39"
            }
        }
    if hotel_code == '100':
        response = {
            "hotel_details": {
                "hotel_ref": {
                    "code": "100"
                },
                "address_details": {
                    "postal_code": "129366",
                    "country": "Российская Федерация",
                    "region": "г. Москва",
                    "city_name": "Москва",
                    "full_address": "129366, г. Москва, Москва, пр-т Мира, д. 150"
                },
                "contact_info": [
                    {
                        "name": "Красильникова Василина Юрьевна",
                        "position": "Менеджер",
                        "phone": "74952341505",
                        "email": "vkrasilnikova@hotelcosmos.ru",
                        "contact_type": "contract"
                    },
                    {
                        "name": "Красильникова Василина Юрьевна",
                        "position": "Менеджер",
                        "phone": "74952341505",
                        "email": "vkrasilnikova@hotelcosmos.ru",
                        "contact_type": "offer"
                    },
                    {
                        "email": "reservations@hotelcosmos.ru",
                        "contact_type": "accountant"
                    },
                    {
                        "phone": "74952341206",
                        "contact_type": "reservation"
                    }
                ],
                "bank_account_details": {
                    "person_legal_name": "ПАО \"ГК \"КОСМОС\"",
                    "address_details": {
                        "postal_code": "129366",
                        "country": "Российская Федерация",
                        "region": "г. Москва",
                        "city_name": "г. Москва",
                        "full_address": "129366, г. Москва, г. Москва, пр-кт. Мира дом 150"
                    },
                    "phone": "+74952341206",
                    "inn": "7717016198",
                    "kpp": "771701001",
                    "bank_name": "БАНК ГПБ (АО)",
                    "bic": "044525823",
                    "corresponding_account": "30101810200000000823",
                    "current_account": "40702810800000001006",
                    "tax": "common"
                },
                "offer_status": "accepted",
                "offer_updated_at": "2020-06-29 11:43"
            }
        }

    return jsonify(response)


@app.route('/bnovo/auth', methods=['POST'])
def bnovo_auth():
    response = {
        "token": "123"
    }
    return jsonify(response)


@app.route('/bnovo/yandex_hotel_details')
def bnovo_hotel_details():
    hotel_code = request.args.get('account_id')
    if hotel_code == '1685':  # bnovo
        response = {
            "hotel_details": {
                "hotel_code": "1685",
                "address": {
                    "postal_code": "191186",
                    "city_name": "Санкт-Петербург",
                    "address_line": "191186, г. Санкт-Петербург, пр-т Мира, д. 150"
                },
                "contact_info": [
                    {
                        "name": "Анна Иванова",
                        "position": "Руководитель отдела продаж",
                        "phone": "+7 987 654 32 10",
                        "email": "anna.ivanova@pushkainn.ru",
                        "contact_type": "contract"
                    },
                    {
                        "phone": "+7 987 654 32 10",
                        "contact_type": "reservation"
                    },
                    {
                        "email": "accountants@pushkainn.ru",
                        "contact_type": "accountant"
                    }],
                "bank_account_details": {
                    "person_legal_name": "ООО \"ПУШКА ИНН-СЕРВИС\"",
                    "branch_name": "Филиал ООО \"ПУШКА ИНН-СЕРВИС\" в Новосибирске",
                    "country": "Российская Федерация",
                    "address": {
                        "postal_code": "191186",
                        "city_name": "Санкт-Петербург",
                        "address_line": "191186, г. Санкт-Петербург, пр-т Мира, д. 150"
                    },
                    "phone": "+7 987 654 32 10",
                    "inn": "7842145232",
                    "kpp": "123456789",
                    "bank_name": "ПАО \"БАНК \"САНКТ-ПЕТЕРБУРГ\"",
                    "bic": "044030790",
                    "corresponding_account": "30101810900000000790",
                    "current_account": "40702810190190000480",
                    "tax": "common"
                },
                "connection_status": "connected",
                "connection_status_updated_at": "2019-09-14 00:39:00"
            }
        }

    return jsonify(response)


@app.route('/bnovo/yandex_hotel_status_changed', methods=['POST'])
def bnovo_hotel_status_changed():
    hotel_code = request.args.get('hotel_code')
    print('Hotel status changed for Bnovo hotel: ' + str(hotel_code))
    url = 'http://localhost:8086/bnovo/hotel_status'
    r = requests.get(
        url,
        params={'hotel_code': hotel_code},
        headers={'Authorization': 'ApiKey 123123'}).json()
    print(r)
    return jsonify({})


@app.route('/hotel_status_changed')
def hotel_status_changed():
    hotel_code = request.args.get('hotel.code')
    print('Hotel status changed for hotel: ' + str(hotel_code))
    url = 'http://localhost:8086/travelline/hotel_status'
    r = requests.get(
        url,
        params={'hotel.code': hotel_code},
        headers={'Authorization': 'ApiKey 123123'}).json()
    print(r)
    return jsonify({})


if __name__ == '__main__':
    app.run(port=8083)
