#pragma once

#include <util/generic/string.h>

namespace NTravel {
namespace NEncryption {

class TUrlCodec {
public:
    TUrlCodec(const TString& keyFile);

    TString Encode(const TString& plainData) const;
    TString Decode(const TString& encodedData) const;
private:
    const TString Key_;
};

class TTokenCodec {
public:
    TTokenCodec(const TString& keyFile);

    TString Encode(const TString& plainData) const;
    TString Decode(const TString& encodedData) const;
private:
    const TString Key_;
};

class TBase64Codec {
public:
    TString Encode(const TString& plainData) const;
    TString Decode(const TString& encodedData) const;
};


} //NEncryption
} //NTravel
