#include "grpc_async_server.h"

namespace NTravel {
namespace NGrpc {

const TString TServerRespMetadata::METADATA_ERROR_KEY = "ya-error-bin";

TString GetMetadata(const grpc::ServerContext& context, const grpc::string_ref& name, const TString& defValue) {
    auto it = context.client_metadata().find(name);
    if (it == context.client_metadata().end()) {
        return defValue;
    }
    return TString(it->second.data(), it->second.size());
}

static std::initializer_list<int> g_TimeBuckets = {0, 1, 5, 10, 20, 50, 100, 250, 500, 1000, 2000, 5000, 10000};

TAsyncServerCountersPerMethod::TAsyncServerCountersPerMethod()
    : TimeWaitingForRequestMs(g_TimeBuckets)
    , TimeWaitingForProcessingMs(g_TimeBuckets)
    , TimeProcessingRequestMs(g_TimeBuckets)
    , TimeSendingResponseMs(g_TimeBuckets)
{
}

void TAsyncServerCountersPerMethod::QueryCounters(NMonitor::TCounterTable* ct) const {
    ct->insert(MAKE_COUNTER_PAIR(NActiveProcessThreads));
    ct->insert(MAKE_COUNTER_PAIR(NActiveJobs));
    ct->insert(MAKE_COUNTER_PAIR(NRequests));
    ct->insert(MAKE_COUNTER_PAIR(NRespOK));
    ct->insert(MAKE_COUNTER_PAIR(NRespInvalidArgument));
    ct->insert(MAKE_COUNTER_PAIR(NRespError));

    TimeWaitingForRequestMs.QueryCounters("TimeWaitingForRequestMs", "", ct);
    TimeWaitingForProcessingMs.QueryCounters("TimeWaitingForProcessingMs", "", ct);
    TimeProcessingRequestMs.QueryCounters("TimeProcessingRequestMs", "", ct);
    TimeSendingResponseMs.QueryCounters("TimeSendingResponseMs", "", ct);

    ct->insert(MAKE_COUNTER_PAIR(NTvmNoTicket));
    ct->insert(MAKE_COUNTER_PAIR(NTvmTicketRefused));
}

void TAsyncServerCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
    ct->insert(MAKE_COUNTER_PAIR(NCompletionQueueMisses));
}

}// Namespace NGrpc
}// Namespace NTravel
