#pragma once

#include <google/protobuf/message.h>
#include <util/generic/string.h>

namespace NTravel {
namespace NLabel {

class TLabelCodec {
public:
    struct TOpts {
        bool WithPrefix_ = false;
        bool WithCheckSum_ = true;

        TOpts& WithPrefix(bool v) { WithPrefix_ = v; return *this; }
        TOpts& WithCheckSum(bool v) { WithCheckSum_ = v; return *this; }
    };

    TString Encode(const TString& plainData, const TOpts& opts) const;
    TString Encode(const ::google::protobuf::MessageLite& label, const TOpts& opts) const;

    TString Decode(const TString& encodedData, const TOpts& opts) const;
    void DecodeToMessage(const TString& encodedData, ::google::protobuf::MessageLite* message, const TOpts& opts) const;

    bool HasPrefix(const TString& encodedData) const;
};

TString CalcLabelHash(const ::google::protobuf::MessageLite& label);

} //NLabel
} //NTravel
