#pragma once

#include "json_logger.h"
#include "unified_agent_logger.h"

#include "travel/hotels/proto/app_config/logger.pb.h"

namespace NTravel {

template <class TRecord>
class TCommonLogger {
public:
    TCommonLogger(TString name, NTravelProto::NAppConfig::TConfigLogger config)
        : JsonLogger_(name, config.GetJson())
        , UnifiedAgentLogger_(name, config.GetUnifiedAgent())
    {
    }

    ~TCommonLogger() {
        Stop();
    }

    void RegisterCounters(NMonitor::TCounterSource& source) {
        UnifiedAgentLogger_.RegisterCounters(source);
        JsonLogger_.RegisterCounters(source);
    }

    void Start() {
        JsonLogger_.Start();
        UnifiedAgentLogger_.Start();
    }

    void Stop() {
        UnifiedAgentLogger_.Stop();
        JsonLogger_.Stop();
    }

    void Reopen() {
        JsonLogger_.Reopen();
    }

    void AddRecord(const TRecord& pbRec) {
        JsonLogger_.AddRecord(pbRec);
        UnifiedAgentLogger_.AddRecord(pbRec);
    }

    // Specially for test, so only JSON is checked
    bool IsFlushed() const {
        return JsonLogger_.IsFlushed();
    }

private:
    TJsonLogger<TRecord> JsonLogger_;
    TUnifiedAgentLogger<TRecord> UnifiedAgentLogger_;
};

}// NTravel
