#pragma once

#include <travel/hotels/proto/app_config/logger.pb.h>
#include <travel/hotels/lib/cpp/util/flag.h>

#include <logbroker/unified_agent/client/cpp/client.h>

#include <library/cpp/protobuf/json/proto2json.h>
#include <util/thread/lfqueue.h>
#include <util/thread/factory.h>
#include <library/cpp/deprecated/atomic/atomic.h>

#include <google/protobuf/message.h>

#include <utility>
#include <travel/hotels/lib/cpp/mon/counter.h>
#include <library/cpp/json/json_value.h>
#include <library/cpp/json/json_writer.h>

namespace NTravel {
    class TLoggerMessageSerializer {
    public:
        const NProtobufJson::TProto2JsonConfig ProtoToJsonCfg;
        const NJson::TJsonWriterConfig JsonConfig;

        TLoggerMessageSerializer();
        TString Serialize(const google::protobuf::Message& data);

    private:
        static NProtobufJson::TProto2JsonConfig CreateProtoToJsonCfg();
        static NJson::TJsonWriterConfig CreateJsonCfg(const NProtobufJson::TProto2JsonConfig& protoToJsonCfg);
        static void PatchJson(NJson::TJsonValue* json);
    };
}
